-- Document Re-submission Application Owner

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'DOCUMENT_RESUBMISSION_APPLICATION_OWNER');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='DOCUMENT_RESUBMISSION_APPLICATION_OWNER');

INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'DOCUMENT_RESUBMISSION_APPLICATION_OWNER', 'Document Re-submission Application Owner', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Document Re-submission Application Owner');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'DOCUMENT_RESUBMISSION_APPLICATION_OWNER_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'DOCUMENT_RESUBMISSION_APPLICATION_OWNER_RECIPIENT', 'SQL');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DOCUMENT_RESUBMISSION_APPLICATION_OWNER_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'DOCUMENT_RESUBMISSION_APPLICATION_OWNER_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DOCUMENT_RESUBMISSION_APPLICATION_OWNER_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='DOCUMENT_RESUBMISSION_APPLICATION_OWNER_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DOCUMENT_RESUBMISSION_APPLICATION_OWNER_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT T1.id as USER_ID FROM
        	 `post_school_studies_section` T1 
		      WHERE T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DOCUMENT_RESUBMISSION_APPLICATION_OWNER_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
     T1.`id` AS ID,    
     T4.`firstName` AS FIRST_NAME,
     T4.`middleName` AS MIDDLE_NAME,
     T4.`lastName` AS LAST_NAME,    
     T19.`emailId` AS EMAIL_ID,
     T15.`mobileNumber` AS MOBILE_NO,
     T9.`code` AS ApplicationId,
     T19.`firstName` AS APPLICATION_OWNER_FIRST_NAME,
     T19.`lastName` AS APPLICATION_OWNER_LAST_NAME,
     T19.`emailId` AS APPLICATION_OWNER_EMAIL,
     date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE,
    (Case 
           when 
               T1.documentsUploadedStatus = 'T'
           then 
               REPLACE(REPLACE(CONCAT(SUBSTRING_INDEX(T1.transcript_path,T1.applicant_person_id, -1) ,' ','(Transcript)'),'\\\\',''),'/','')
 		  when 
               T1.documentsUploadedStatus = 'C'
           then 
 			  REPLACE(REPLACE(CONCAT(SUBSTRING_INDEX(T1.certificate_path,T1.applicant_person_id, -1) ,' ','(Certificate)'),'\\\\',''),'/','')
 		  when 
               T1.documentsUploadedStatus = 'BOTH'
           then 
 			  CONCAT(REPLACE(REPLACE(CONCAT(SUBSTRING_INDEX(T1.transcript_path,T1.applicant_person_id, -1) ,' ','(Transcript)'),'\\\\',''),'/',''),' and ',REPLACE(REPLACE(CONCAT(SUBSTRING_INDEX(T1.certificate_path,T1.applicant_person_id, -1) ,' ','(Certificate)'),'\\\\',''),'/',''))
 end) as DOCUMENT_NAME,
 GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
 FROM
     post_school_studies_section T1
          LEFT JOIN
     applicant_person T4 ON T4.id = T1.applicant_person_id
 	Left JOIN
    application T9 on T4.id = T9.applicantPersonId      
         LEFT OUTER JOIN
     users T19 on T19.id = T9.applicationOwner
     LEFT OUTER JOIN
 	staffs T14 on T14.userId = T19.id
 		LEFT OUTER JOIN
 	persons T15 on T15.id = T14.personId
     LEFT JOIN
    fire_base_persons_info f ON f.userId = T19.id
 WHERE
     T1.id IN (namedParams) limit 1",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },		 
		 {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
	{
            "id": 3,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2  
	},
	{
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },{
            "id": 5,
            "value": "code",
            "resultKey": "ApplicationId",
            "displayCode": "",
            "displayOrder": 4
        },
	{
            "id": 6,
            "value": "firstName",
            "resultKey": "APPLICATION_OWNER_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
	{
            "id": 7,
            "value": "lastName",
            "resultKey": "APPLICATION_OWNER_LAST_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "TODAY_DATE",
            "resultKey": "TODAY_DATE",
            "displayCode": "",
            "displayOrder": 7
        },
	{
           "id": 9,
            "value": "documentsUploadedStatus",
            "resultKey": "DOCUMENT_NAME",
            "displayCode": "",
            "displayOrder": 8
	}
]}');


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='DOCUMENT_RESUBMISSION_APPLICATION_OWNER');


SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='DOCUMENT_RESUBMISSION_APPLICATION_OWNER');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='DOCUMENT_RESUBMISSION_APPLICATION_OWNER_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'Document Re-submission Application Owner Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Document Re-submission Application Owner Template',NULL,'',NULL,'','APPROVED','','1','System Admin','1','English',b'1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Document Re-submission Application Owner','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear <strong>$recipientData[&quot;APPLICATION_OWNER_FIRST_NAME&quot;]&nbsp;$recipientData[&quot;APPLICATION_OWNER_LAST_NAME&quot;]</strong>,&nbsp;<br />
			The Applicant $recipientData[&quot;ApplicationId&quot;]/$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;] has re-submitted the Documents $recipientData[&quot;DOCUMENT_NAME&quot;] for verification on $recipientData[&quot;TODAY_DATE&quot;].</span><br />
			Please login to the portal and verify the document from your end for further processes. </span></p>
			</td>
		</tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'4','Document Re-submission Application Owner','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p><span style="font-family: arial, helvetica, sans-serif; font-size: 12px;">Dear </span><strong style="font-family: arial, helvetica, sans-serif; font-size: 12px;">$recipientData[&quot;APPLICATION_OWNER_FIRST_NAME&quot;]&nbsp;$recipientData[&quot;APPLICATION_OWNER_LAST_NAME&quot;]</strong><span style="font-family: arial, helvetica, sans-serif; font-size: 12px;">,&nbsp;</span></p>

<p><span style="font-family: arial, helvetica, sans-serif; font-size: 12px;">The Applicant $recipientData[&quot;ApplicationId&quot;]/$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;] has re-submitted the document $recipientData[&quot;DOCUMENT_NAME&quot;] for verification on $recipientData[&quot;TODAY_DATE&quot;].</span></p>

<p><span style="font-size:12px;">Please login to the portal and verify the document from your end for further processes. </span></p>
<title></title>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData["APPLICATION_OWNER_FIRST_NAME"] $recipientData["APPLICATION_OWNER_LAST_NAME"], The Applicant $recipientData["ApplicationId"] / $recipientData["FIRST_NAME"] $recipientData["LAST_NAME"] has re-submitted the document $recipientData["DOCUMENT_NAME"] for verification on $recipientData["TODAY_DATE"]. Please login to the portal and verify the document from your end for further processes.');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+4,@msgtemplateconfigId+1,'6','Message','Dear $recipientData["APPLICATION_OWNER_FIRST_NAME"] $recipientData["APPLICATION_OWNER_LAST_NAME"], The Applicant $recipientData["ApplicationId"] / $recipientData["FIRST_NAME"] $recipientData["LAST_NAME"] has re-submitted the document $recipientData["DOCUMENT_NAME"] for verification on $recipientData["TODAY_DATE"] .Please login to the portal and verify the document from your end for further processes.');


